import { View, Text } from "react-native";
import React from "react";
import { Onboard1Style } from "./Onboard1Style";
import { OnboardDP } from "./OnboardDP";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const Onboard1 = ({ item, currentSlideIndex }) => {
    const { OnboardIcon, title1, title2, title3, title4, text1, text2 } = item;
    const { illustration3Icon, illustration2Icon } = OnboardDP();
    return (
        <View style={Onboard1Style.container}>
            {currentSlideIndex === 0 && (
                <>
                    <CustomSVG svgIcon={OnboardIcon}
                        style={Onboard1Style.illustration1}
                        height={illustration2Icon.height}
                    />
                    <View style={Onboard1Style.textTitleContainer}>
                        <View>
                            <Text style={Onboard1Style.title}>{title1}</Text>
                            <Text style={Onboard1Style.title}>{title2}</Text>
                            <Text style={Onboard1Style.title}>{title3}</Text>
                            <Text style={Onboard1Style.title}>{title4}</Text>
                        </View>
                        <View style={Onboard1Style.textContainer}>
                            <Text style={Onboard1Style.text}>{text1}</Text>
                            <Text style={Onboard1Style.text}>{text2}</Text>
                        </View>
                    </View>
                </>
            )}
            {currentSlideIndex === 1 && (
                <>
                    <CustomSVG svgIcon={OnboardIcon}
                        style={Onboard1Style.illustration2}
                        height={illustration2Icon.height}
                    />
                    <View style={Onboard1Style.textTitleContainer}>
                        <View>
                            <Text style={Onboard1Style.title2}>{title1}</Text>
                            <Text style={Onboard1Style.title2}>{title2}</Text>
                            <Text style={Onboard1Style.title2}>{title3}</Text>
                            <Text style={Onboard1Style.title2}>{title4}</Text>
                        </View>
                        <View style={Onboard1Style.textContainer}>
                            <Text style={Onboard1Style.text2}>{text1}</Text>
                            <Text style={Onboard1Style.text2}>{text2}</Text>
                        </View>
                    </View>
                </>
            )}
            {currentSlideIndex === 2 && (
                <>
                    <CustomSVG svgIcon={OnboardIcon}
                        style={Onboard1Style.illustration3}
                        height={illustration3Icon.height}
                        width={illustration3Icon.width}
                    />
                    <View style={Onboard1Style.textTitleContainer2}>
                        <View>
                            <Text style={Onboard1Style.title3}>{title1}</Text>
                            <Text style={Onboard1Style.title3}>{title2}</Text>
                            <Text style={Onboard1Style.title3}>{title3}</Text>
                        </View>
                        <View style={Onboard1Style.textContainer}>
                            <Text style={Onboard1Style.text3}>{text1}</Text>
                            <Text style={Onboard1Style.text3}>{text2}</Text>
                        </View>
                    </View>
                </>
            )}
        </View>
    );
};

export default Onboard1;
